# ESP-WROVER32 AT V0.10 Release Note
This is the first release of ESP32 AT firmware, which supports AT commands through UART.   

Here is a list of AT commands. More details are in documentation [esp32_at_instruction_set_and_examples_en.pdf](http://espressif.com/sites/default/files/documentation/esp32_at_instruction_set_and_examples_en.pdf) or 
[esp32_at_instruction_set_and_examples_cn.pdf](http://espressif.com/sites/default/files/documentation/esp32_at_instruction_set_and_examples_cn.pdf).
  
The ESP32 sends AT commands through UART1 by default, for ESP-WROVER32, it is:

* GPIO19 is RXD
* GPIO22 is TXD
* GPIO14 is RTS
* GPIO15 is CTS
  
  
## Basic AT Commands
* AT : Tests AT startup.
* AT+RST : Restarts a module.
* AT+GMR : Checks version information.
* AT+GSLP : Enters Deep-sleep mode.
* ATE : Configures echoing of AT commands.
* AT+RESTORE : Restores the factory default settings of the module.
* AT+UART : UART configuration.
* AT+UART_CUR : Current UART configuration.
* AT+UART_DEF : Default UART configuration, saved in flash.
* AT+SLEEP : Sets the sleep mode.
* AT+SYSRAM : Checks the remaining space of RAM.

## Wi-Fi AT Commands
* AT+CWMODE : Sets the Wi-Fi mode (STA/AP/STA+AP).
* AT+CWJAP : Connects to an AP.
* AT+CWLAPOPT : Sets the configuration of command AT+CWLAP.
* AT+CWLAP : Lists available APs.
* AT+CWQAP : Disconnects from the AP.
* AT+CWSAP : Sets the configuration of the ESP32 SoftAP.
* AT+CWLIF : Gets the Station IP to which the ESP32 SoftAP is connected.
* AT+CWDHCP : Enables/disables DHCP.
* AT+CWDHCPS : Sets the IP range of the ESP32 SoftAP DHCP server. Saves the setting in flash.
* AT+CWAUTOCONN : Connects to the AP automatically on power-up.
* AT+CIPSTAMAC : Sets the MAC address of ESP32 Station.
* AT+CIPAPMAC : Sets the MAC address of ESP32 SoftAP.
* AT+CIPSTA : Sets the IP address of ESP32 Station.
* AT+CIPAP : Sets the IP address of ESP32 SoftAP.
* AT+CWSTARTSMART : Starts SmartConfig.
* AT+CWSTOPSMART : Stops SmartConfig.
* AT+WPS : Enables the WPS function.

## TCP/IP-Related AT Commands
* AT+CIPSTATUS : Gets the connection status.
* AT+CIPDOMAIN : DNS function.
* AT+CIPSTART : Establishes TCP connection, UDP transmission or SSL connection.
* AT+CIPSEND : Sends data.
* AT+CIPSENDEX : Sends data when length of data is <length>, or when \0 appears in the data.
* AT+CIPCLOSE : Closes TCP/UDP/SSL connection.
* AT+CIFSR : Gets the local IP address.
* AT+CIPMUX : Configures the multiple connections mode.
* AT+CIPSERVER : Deletes/Creates TCP server.
* AT+CIPMODE : Configures the transmission mode.
* AT+SAVETRANSLINK : Saves the transparent transmission link in flash.
* AT+CIPSTO : Sets timeout when ESP32 runs as a TCP server.
* AT+CIUPDATE : Updates the software through Wi-Fi.
* AT+CIPDINFO : Shows remote IP and remote port with +IPD.
* AT+CIPSNTPCFG : Configures the time domain and SNTP server.
* AT+CIPSNTPTIME : Queries the SNTP time.
